#!/usr/bin/perl

##################################################################
###                                               13.02.1999   ###
###  TimeImg - automatisierte Grafik-Rotation                  ###
###  v 1.00                                                    ###
###                                                            ###
###  Dieses Skript darf kostenlos eingesetzt werden.           ###
###  Sie knnen das Skript bei Bedarf ndern, jedoch mssen    ###
###  diese Zeilen stets erhalten bleiben.                      ###
###                                                            ###
###  Beschreibung:                                             ###
###  Durch TimeImg lt sich eine Grafik (GIF oder JPG) je     ###
###  nach aktueller Tageszeit automatisch austauschen.         ###
###                                                            ###
###  Einsatz:                                                  ###
###  <img src="/cgi-bin/timeimg.pl?rotation1">                 ###
###  wobei "rotation1" ein Verzeichnis ist, in dem sich die    ###
###  Rotations-Grafiken befinden.                              ###
###                                                            ###
###  Informationen und weitere NEUE Skripte finden Sie unter:  ###
###  http://www.shoppark.de/sitepro/                           ###
###                                                            ###
###  Bjrn Hahne                                               ###
###  bhahne@shoppark.de                                        ###
##################################################################


###############################
# Konfigurations Teil Anfang  #
###############################


$base_path="../timeimg/";  # Geben Sie hier den Basis-Pfad zum Verzeichnis an, wo Sie Grafiken ablegen mchten.
                           # Beispiel:
                           # /cgi-bin/timeimg.pl      => Installation des Skriptes
                           # /timeimg/                => ein angelegtes Verzeichnis
                           # /timeimg/rotation1/      => Verz. fr Rotations-Grafiken "rotation1"
                           # /timeimg/rotation2/      => Verz. fr Rotations-Grafiken "rotation2
                           # => bennen Sie base_path so:
                           # $base_path="../timeimg/";
                           # WICHTIG: Bei Windows-NT verwenden Sie bitte einen zweifachen Backslash:
                           # $base_path="c:\\timeimg\\";

$zeitzone_dif=0;           # Falls sich der Server in den USA befindet, Sie aber die Grafik-Rotat. auf
                           # Basis der MEZ ausgeben mchten, knnen Sie hier eine Zeitonen-Differenz
                           # in Stunden angeben.


###############################
# Konfigurations Teil Ende    #
###############################


$buffer=&ReadParse;                       # Buffer einlesen
$path=$base_path.$buffer;                 # Pfad des Verzeichnis = Basis Pfad + Paramter bergabe

($sec,$min,$hour,$mday,$mon,$year,
$wday,$yday,$isdst) = localtime(time);    # Zeit ermitteln
$hour=int($hour);                         # Stunde muss Zahl sein

$pic=&search_pic($hour);                  # Bildname aus Uhrzeit ermitteln
&print_gif($pic);                         # Bild ausgeben

# ==========================================================================================
# Sucht nach Bild
# ==========================================================================================

sub search_pic {
  local($hour)=@_;                        # Zeit einlesen
  local($start_hour);
  $hour+=$zeitzone_dif;
  if ($hour>23) {$hour=$hour-24}
  $start_hour=$hour;                      # Start-Zeit merken
  do {
    if (-e "$path\/pic$hour.gif") {return "$path\/pic$hour.gif";}       # Falls GIF-Grafik existiert, Grafik zurckgeben
    if (-e "$path\/pic$hour.jpg") {return "$path\/pic$hour.jpg";}       # Falls JPG-Grafik existiert, Grafik zurckgeben
    $hour--;                              # sonst vorherige Stunde
    if ($hour==-1) {$hour=23;}

  } while ($hour!=$start_hour);           # Falls Uhrzeit = Startzeit, keine Grafik gefunden
   return "not found";
}

# ==========================================================================================
# Gibt GIF oder JPG Grafik aus
# ==========================================================================================

sub print_gif {
  local($filename)=$_[0];                 # Filename einlesen
  if ($filename=~/.jpg/i) {               # Falls JPG-Grafik...
    print ("Content-type: image/jpeg\n\n")  # JPEG ausgeben
  }
  else {                                  # sonst...
    print ("Content-type: image/gif\n\n") # GIF ausgeben
  }
  open (GIF, "$filename");                # File ffnen
  print <GIF>;                            # und ausgeben
  close (GIF);                            # File schliessen
  exit;
}

# ==========================================================================================
# Liest Formulareingaben und speichert diese in $input{"key"}=value;
# ==========================================================================================

sub ReadParse {
 local($buffer);
 local($namebuffer,$valuebuffer);

 if ($ENV{'REQUEST_METHOD'} eq "GET") { $buffer = $ENV{'QUERY_STRING'}; }
 else { read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});  }

 if (!($buffer)) {$buffer=substr($ENV{'PATH_INFO'},1,length($ENV{'PATH_INFO'}));}
 if (!($buffer)) {$buffer=@ARGV; }

 @nvpairs = split(/&/,$buffer);
 foreach $pair (@nvpairs)
  {
    ($namebuffer, $valuebuffer) = split(/=/, $pair);
    $namebuffer =~ tr/+/ /;
    $namebuffer =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $valuebuffer =~ tr/+/ /;
    $valuebuffer =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $input{$namebuffer}=$valuebuffer;

  }
  return $buffer;
}
